/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockRootyDirtTFC
extends BlockRootyDirt {
    private static final EnumFacing[] NOT_UP = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH};

    public BlockRootyDirtTFC() {
        super(false);
    }

    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        IBlockState mimicState = super.getMimic(access, pos);
        if (mimicState.func_177230_c() == Blocks.field_150346_d) {
            for (int i = 1; i < 4; ++i) {
                for (EnumFacing d : NOT_UP) {
                    IBlockState state = access.func_180495_p(pos.func_177967_a(d, i));
                    if (!(state.func_177230_c() instanceof BlockRockVariant)) continue;
                    Rock rock = ((BlockRockVariant)state.func_177230_c()).getRock();
                    return BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.DIRT).func_176223_P();
                }
            }
            return BlockRockVariant.get((Rock)Rock.LIMESTONE, (Rock.Type)Rock.Type.DIRT).func_176223_P();
        }
        return mimicState;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
        drops.add((Object)new ItemStack(this.getDecayBlockState(world, pos).func_177230_c()));
    }

    public IBlockState getDecayBlockState(IBlockAccess world, BlockPos pos) {
        ChunkDataTFC chunkData;
        if (world instanceof World && (chunkData = (ChunkDataTFC)((World)world).func_175726_f(pos).getCapability(ChunkDataProvider.CHUNK_DATA_CAPABILITY, null)) != null) {
            Rock rock = chunkData.getRockHeight(pos);
            return BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.DIRT).func_176223_P();
        }
        return super.getDecayBlockState(world, pos);
    }
}

